/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import javax.annotation.Nullable;
import org.python.google.common.base.Equivalence;
import org.python.google.common.base.Objects;
import org.python.google.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public final class Equivalences {
    private Equivalences() {
    }

    public static Equivalence<Object> equals() {
        return Impl.EQUALS;
    }

    public static Equivalence<Object> nullAwareEquals() {
        return Impl.NULL_AWARE_EQUALS;
    }

    public static Equivalence<Object> identity() {
        return Impl.IDENTITY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Impl implements Equivalence<Object>
    {
        EQUALS{

            public boolean equivalent(Object object, @Nullable Object object2) {
                Preconditions.checkNotNull(object);
                return object.equals(object2);
            }

            public int hash(Object object) {
                Preconditions.checkNotNull(object);
                return object.hashCode();
            }
        }
        ,
        IDENTITY{

            public boolean equivalent(Object object, @Nullable Object object2) {
                return Preconditions.checkNotNull(object) == object2;
            }

            public int hash(@Nullable Object object) {
                return System.identityHashCode(object);
            }
        }
        ,
        NULL_AWARE_EQUALS{

            public boolean equivalent(@Nullable Object object, @Nullable Object object2) {
                return Objects.equal(object, object2);
            }

            public int hash(@Nullable Object object) {
                return object == null ? 0 : object.hashCode();
            }
        };

    }
}

